/*
 * Application core
 * 
 * - supervisor (owner in most of modules/classes)
 * - initializes server
 * - initializes sections and loads sections default styles 
 */
var Core = new Class({
	section: null,
	el: null,
	classesDirectory: "js/classes/",
	cssDirectory: "css/",
	server: null,
	user: null,
	
	initialize: function(){
		this.el = $('_main');
		this.server = new Server();
		
		// TODO - presunut logout do User?
		// watch for application close
		window.nativeWindow.addEventListener(air.Event.CLOSING, function(){
			this.fireEvent('closing');
      this.logout(false);
		}.bind(this));
		
		// watch for application close
		window.nativeWindow.addEventListener(air.Event.CLOSE, function(){
			this.fireEvent('close');
		}.bind(this));
	},
	
	logout: function(manual){
		if (!$defined(this.user)) return;
    this.user.logout(manual);
    this.user = null;
		if (manual) this.loadSection('login');
	},

  // changes section
	loadSection: function(name){
		switch(name){
			case 'login':
			  this.section = new Login(this);
			  break;
      case 'registration':
        this.section = new Registration(this);
        break;
		  case 'main':
			  this.section = new Main(this); 
				break;
			default: 
			  this.section = null;
		}
		
		this.loadCSS(name);

		if($defined(this.section)) {
			// load another section on section ask			
			this.section.addEvent('SectionChange', this.loadSection.bind(this));
		}

    this.showSection();
		return this;
	},
	
	// load css file named {name}.css
	loadCSS: function(name){
		var file = air.File.applicationDirectory.resolvePath(this.cssDirectory+name+'.css');
    if(file.exists){
      new Asset.css(this.cssDirectory+name+'.css');
    }
	},
	
	// cleans screen and shows section element
	showSection: function(){
		this.el.empty().adopt(this.section.getEl());
		
    this.el.addEvent('domready', function(){
			this.getElements('').addEvents({
        'mouseover': function(e){this.addClass('hover');},
        'mouseout': function(e){this.removeClass('hover');},
      });
			
	    this.getElements('input[type!=submit]').addEvent('focus', function(e){
				this.addClass('focus');
	    }).addEvent('blur', function(e){
	      this.removeClass('focus');
	    });
			
			this.getElements('input[type=submit]').addEvents({
				'mouseover': function(e){this.addClass('button_mouseover');},
				'mouseout': function(e){this.removeClass('button_mouseover');},
			}).addClass('button');
		});
    
		return this;
	}
});

Core.implement(new Events);